/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sourceforge.plantuml.code.AsciiEncoder;

public class SignatureUtils {
    public static String getSignature(String s) {
        try {
            AsciiEncoder coder = new AsciiEncoder();
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            msgDigest.update(s.getBytes("UTF-8"));
            byte[] digest = msgDigest.digest();
            return coder.encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String getSignatureSha512(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            String string = SignatureUtils.getSignatureSha512(is);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static String getSignatureSha512(InputStream is) throws IOException {
        try {
            AsciiEncoder coder = new AsciiEncoder();
            MessageDigest msgDigest = MessageDigest.getInstance("SHA-512");
            int read = 0;
            while ((read = is.read()) != -1) {
                msgDigest.update((byte)read);
            }
            byte[] digest = msgDigest.digest();
            return coder.encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String getSignatureWithoutImgSrc(String s) {
        s = SignatureUtils.getSignature(SignatureUtils.purge(s));
        return s;
    }

    public static String purge(String s) {
        String regex = "(?i)\\<img\\s+src=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"/\\>";
        s = s.replaceAll("(?i)\\<img\\s+src=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"/\\>", "<img src=\"$1$2\"/>");
        String regex2 = "(?i)image=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"";
        s = s.replaceAll("(?i)image=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"", "image=\"$1$2\"");
        return s;
    }

    public static String getSignature(File f) throws IOException {
        try {
            AsciiEncoder coder = new AsciiEncoder();
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(f);
            int read = -1;
            while ((read = is.read()) != -1) {
                msgDigest.update((byte)read);
            }
            is.close();
            byte[] digest = msgDigest.digest();
            return coder.encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }
}

