/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import net.sourceforge.plantuml.code.ArobaseStringCompressor;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.AsciiEncoderBase64;
import net.sourceforge.plantuml.code.AsciiEncoderHex;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.CompressionHuffman;
import net.sourceforge.plantuml.code.CompressionNone;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;

public class TranscoderSmart
implements Transcoder {
    private final Transcoder oldOne = new TranscoderImpl(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionHuffman());
    private final Transcoder zlib = new TranscoderImpl(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionZlib());
    private final Transcoder brotli = new TranscoderImpl(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionBrotli());
    private final Transcoder zlibBase64 = new TranscoderImpl(new AsciiEncoderBase64(), new ArobaseStringCompressor(), new CompressionZlib());
    private final Transcoder brotliBase64 = new TranscoderImpl(new AsciiEncoderBase64(), new ArobaseStringCompressor(), new CompressionBrotli());
    private final Transcoder base64only = new TranscoderImpl(new AsciiEncoderBase64(), new ArobaseStringCompressor(), new CompressionNone());
    private final Transcoder hexOnly = new TranscoderImpl(new AsciiEncoderHex(), new ArobaseStringCompressor(), new CompressionNone());

    @Override
    public String decode(String code) throws IOException {
        if (code.startsWith("0A")) {
            return this.zlibBase64.decode(code.substring(2));
        }
        if (code.startsWith("0B")) {
            return this.brotliBase64.decode(code.substring(2));
        }
        if (code.startsWith("0C")) {
            return this.base64only.decode(code.substring(2));
        }
        if (code.startsWith("0D")) {
            return this.hexOnly.decode(code.substring(2));
        }
        if (code.startsWith("-zlib-")) {
            return this.zlibBase64.decode(code.substring("-zlib-".length()));
        }
        if (code.startsWith("-brotli-")) {
            return this.brotliBase64.decode(code.substring("-brotli-".length()));
        }
        if (code.startsWith("-base64-")) {
            return this.base64only.decode(code.substring("-base64-".length()));
        }
        if (code.startsWith("-hex-")) {
            return this.hexOnly.decode(code.substring("-hex-".length()));
        }
        if (code.startsWith("0")) {
            return this.brotli.decode(code.substring(1));
        }
        try {
            return this.zlib.decode(code);
        }
        catch (Exception ex) {
            return this.oldOne.decode(code);
        }
    }

    @Override
    public String encode(String text) throws IOException {
        return this.zlib.encode(text);
    }
}

