/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;

public class CommandMultilinesLegend
extends CommandMultilines2<UmlDiagram> {
    public CommandMultilinesLegend() {
        super(CommandMultilinesLegend.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("legend"), new RegexLeaf("VALIGN", "(?:[%s]+(top|bottom))?"), new RegexLeaf("ALIGN", "(?:[%s]+(left|right|center))?"), new RegexLeaf("$"));
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?legend$";
    }

    @Override
    public CommandExecutionResult executeNow(UmlDiagram diagram, BlocLines lines) {
        lines = lines.trimSmart(1);
        RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
        String align = line0.get("ALIGN", 0);
        String valign = line0.get("VALIGN", 0);
        lines = lines.subExtract(1, 1);
        Display strings = (lines = lines.removeEmptyColumns()).toDisplay();
        if (strings.size() > 0) {
            VerticalAlignment valignment = VerticalAlignment.fromString(valign);
            HorizontalAlignment alignment = HorizontalAlignment.fromString(align);
            if (alignment == null) {
                alignment = HorizontalAlignment.CENTER;
            }
            diagram.setLegend(DisplayPositionned.single(strings, alignment, valignment));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("No legend defined");
    }
}

