/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "6rO702mEpFCVHV0StDQFZQ4KYXIQJO-ICGuxFM7I4cYu9-jpVDvE66nDSPvH5Fk0vi0crmphPDt6pjY2uBcYk88Aa1TYgjX-ouJsTXreG_9MC8x0dygP_yi5DYP8xwonAVBmEA0r5cwBnhJ_ZygwwBzeW4wmQLIsB2eDyYodLy4aXy6fi-EKKF9GZEahKfJronQWb8u5cMrdTOGVP9jzenQfIMis3PbP0ehBI95eFZPQsNTo-rx62I1QVZzWAy4E9PAR732Ml16Z8zC3WjGeRiO6QjvvmeC93LHemnSbgQaj93BAm417xXueeFHdd83O9sMKv6p3su3yBR95HOEWZkytflF7XsKfUtvfE4OUa7FG2g02o7-W6_wqDdE9SHcR0ZFaNHZ7ib78QwgNKTuyqDTQ5mRWPV9aHk-N7stV5j8vvJh7hyu6UTMGbKTx66kySWdk-SzS2ksB1LG_WBRjEn3Z_SFvpK9t28yfTI6LS_pE_IO2eXjBOQ4tSSbgzfztwHP3HVDepc8ySh-EjnA17LnNucxeSYr_YZedb6mQwjTBNXqwhYBN-DNcVObUaqr3_7-jbZA3T0UjxiA6ws8493WMLkNYeel0OT2_8RSakP7Q3fD7_R1yYP_t9yczroA1A6mws3_LP-0cDxim6xfqOXCF0AysYNQZe_0WCmYh0nq7bMTas5t_kqdFiAanQTxfre5XDuRwHxgxSZDzCvTq2qE_B9hjkzep70NSYXFAuNUr_hOAPN89xwP5Q7oImVejp1c1z1bHzZrjoNHJ1ymiZmMlwkBltUtapqFd_xwzMzHmTFvxjtzqVPl9p-RKKeyeQzTWsDlWiZPhuqLr0MrBvNcWEpCk0gvN9XigkOMEp72MGyoJ95JsWuDZwC5DdQ1jFR8pDIrXRZrMoS2Mv8VKdJGgjGDFsETsU-SPeqM1_SbvErOzrBSXnTy558aXmLCgm7s45FMmEPrCDywsjBkJxtfhymN3DQfnuKw3meybchJSOF4fm8oT_80qdff8j97NSIPA0B_Zz1lq3DdFhgxRk8wMLW00";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 4, 5);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(new UTranslate(0.0, header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(new UTranslate(x, 0.0)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

