/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.NoteOnMessage;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;

public final class GroupingLeaf
extends Grouping
implements EventWithDeactivate {
    private final GroupingStart start;
    private final HtmlColor backColorGeneral;
    private double posYendLevel;
    private List<NoteOnMessage> noteOnMessages = new ArrayList<NoteOnMessage>();

    public GroupingLeaf(String title, String comment, GroupingType type, HtmlColor backColorGeneral, HtmlColor backColorElement, GroupingStart start) {
        super(title, comment, type, backColorElement);
        if (start == null) {
            throw new IllegalArgumentException();
        }
        this.backColorGeneral = backColorGeneral;
        this.start = start;
        start.addChildren(this);
    }

    public Grouping getJustAfter() {
        int idx = this.start.getChildren().indexOf(this);
        if (idx == -1) {
            throw new IllegalStateException();
        }
        if (idx + 1 >= this.start.getChildren().size()) {
            return null;
        }
        return this.start.getChildren().get(idx + 1);
    }

    public GroupingStart getGroupingStart() {
        return this.start;
    }

    @Override
    public int getLevel() {
        return this.start.getLevel();
    }

    @Override
    public final HtmlColor getBackColorGeneral() {
        if (this.backColorGeneral == null) {
            return this.start.getBackColorGeneral();
        }
        return this.backColorGeneral;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return false;
    }

    @Override
    public Url getUrl() {
        return null;
    }

    @Override
    public boolean hasUrl() {
        return false;
    }

    @Override
    public boolean isParallel() {
        return this.start.isParallel();
    }

    @Override
    public void setPosYendLevel(double posYendLevel) {
        this.posYendLevel = posYendLevel;
    }

    @Override
    public double getPosYendLevel() {
        return this.posYendLevel;
    }

    @Override
    public boolean addLifeEvent(LifeEvent lifeEvent) {
        lifeEvent.setLinkedToGroupingEnd(true);
        return true;
    }

    public final void setNote(Display strings, NotePosition notePosition, NoteStyle noteStyle, String backcolor, Url url) {
        if (notePosition != NotePosition.LEFT && notePosition != NotePosition.RIGHT) {
            throw new IllegalArgumentException();
        }
        this.noteOnMessages.add(new NoteOnMessage(strings, notePosition, noteStyle, backcolor, url));
    }

    public final List<NoteOnMessage> getNoteOnMessages() {
        return this.noteOnMessages;
    }
}

