/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandNoteLong
extends CommandMultilines2<TimingDiagram> {
    public CommandNoteLong() {
        super(CommandNoteLong.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?note$";
    }

    @Override
    public CommandExecutionResult executeNow(TimingDiagram diagram, BlocLines lines) {
        RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        String code = line0.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        Display note = lines.toDisplay();
        TimeTick now = diagram.getNow();
        player.addNote(now, note, Position.fromString(line0.get("POSITION", 0)));
        return CommandExecutionResult.ok();
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("[%s]*note[%s]+"), new RegexLeaf("POSITION", "(top|bottom)[%s]+of[%s]+"), new RegexLeaf("CODE", "([\\p{L}_][\\p{L}0-9_.]*)"), new RegexLeaf("[%s]*$"));
    }
}

