/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimingRuler {
    private final SortedSet<TimeTick> times = new TreeSet<TimeTick>();
    private long highestCommonFactor = -1L;
    private final ISkinParam skinParam;
    private long tickIntervalInPixels = 50L;
    private long tickUnitary;

    public void scaleInPixels(long tick, long pixel) {
        this.tickIntervalInPixels = pixel;
        this.tickUnitary = tick;
    }

    private long tickUnitary() {
        if (this.tickUnitary == 0L) {
            return this.highestCommonFactor;
        }
        return this.tickUnitary;
    }

    private int getNbTick() {
        if (this.times.size() == 0) {
            return 1;
        }
        return (int)(1L + this.getMax().getTime().longValue() / this.tickUnitary());
    }

    public double getWidth() {
        return this.getPosInPixel(new BigDecimal((long)this.getNbTick() * this.tickUnitary()));
    }

    private double getPosInPixel(double time) {
        return time / (double)this.tickUnitary() * (double)this.tickIntervalInPixels;
    }

    public TimingRuler(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public void addTime(TimeTick time) {
        long tick;
        boolean added = this.times.add(time);
        if (added && (tick = time.getTime().longValue()) > 0L) {
            this.highestCommonFactor = this.highestCommonFactor == -1L ? time.getTime().longValue() : TimingRuler.computeHighestCommonFactor(this.highestCommonFactor, time.getTime().longValue());
        }
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.ACTIVITY, null);
    }

    private TextBlock getTimeTextBlock(long time) {
        Display display = Display.getWithNewlines("" + time);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public void draw(UGraphic ug) {
        ug = ug.apply(new UStroke(2.0)).apply(new UChangeColor(HtmlColorUtils.BLACK));
        double tickHeight = 5.0;
        ULine line = new ULine(0.0, 5.0);
        int nb = this.getNbTick();
        for (int i = 0; i <= nb; ++i) {
            ug.apply(new UTranslate(this.tickIntervalInPixels * (long)i, 0.0)).draw(line);
        }
        ug.draw(new ULine((long)nb * this.tickIntervalInPixels, 0.0));
        for (long round : this.roundValues()) {
            TextBlock text = this.getTimeTextBlock(round);
            Dimension2D dim = text.calculateDimension(ug.getStringBounder());
            text.drawU(ug.apply(new UTranslate(this.getPosInPixel(round) - dim.getWidth() / 2.0, 6.0)));
        }
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getTimeTextBlock(0L).calculateDimension(stringBounder).getHeight();
    }

    private Collection<Long> roundValues() {
        TreeSet<Long> result = new TreeSet<Long>();
        if (this.tickUnitary == 0L) {
            for (TimeTick tick : this.times) {
                long round = tick.getTime().longValue();
                result.add(round);
            }
        } else {
            int nb = this.getNbTick();
            for (int i = 0; i <= nb; ++i) {
                long round = this.tickUnitary * (long)i;
                result.add(round);
            }
        }
        return result;
    }

    private TimeTick getMax() {
        if (this.times.size() == 0) {
            throw new IllegalStateException("Empty list!");
        }
        return this.times.last();
    }

    private static long computeHighestCommonFactor(long a, long b) {
        long r = a;
        while (r != 0L) {
            r = a % b;
            a = b;
            b = r;
        }
        return Math.abs(a);
    }

    public final double getPosInPixel(BigDecimal time) {
        return this.getPosInPixel(time.doubleValue());
    }

    public final double getPosInPixel(TimeTick when) {
        return this.getPosInPixel(when.getTime());
    }

    public final double getMaxPosInPixel() {
        return this.getPosInPixel(this.getMax());
    }
}

